﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Competence
{
    public partial class UCTabCompetenceDetails : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        public UCTabCompetenceDetails()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCCompetenceDetails UCDetails
        {
            get { return (UCCompetenceDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            
            UCDetails.DataManager.Bindings.Add(_gTextBoxName, "Name", _gLabelName);
            UCDetails.DataManager.Bindings.Add(_gTextBoxAbbreviation, "Abbreviation", _gLabelAbbreviation);
            UCDetails.DataManager.Bindings.Add(_gCheckBoxIsActive, "IsActive");


            _gftpControlImage.Initialize(UCDetails.Environment, UCDetails.Plugin, true);
            _gftpControlImage.FileFilter = Gemini.Dictionary.FileFilters.Picture;
            _gftpControlImage.OnFileChanged += new CM.N214.FTP.WinForms.GFTPControl.FileChangedEventHandler(ImageChanged);
            _gPictureBox.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
        }

        void ImageChanged()
        {
            if (_gftpControlImage.IsFileExist)
            {
                _gPictureBox.Visible = false;
                _gPictureBox.LoadAsync(_gftpControlImage.URL);
            }
            else
            {
                _gPictureBox.Visible = false;
            }
        }

        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            _gPictureBox.Visible = true;
        }

        public override void DoRestore()
        {
            if (UCDetails.DataManager.Current != null)
            {
                _gftpControlImage.ID = UCDetails.DataManager.Current.ImageFileID;
                if (!String.IsNullOrEmpty(UCDetails.DataManager.Current.ImageFileURL))
                {
                    _gPictureBox.Visible = false;
                    _gPictureBox.LoadAsync(UCDetails.DataManager.Current.ImageFileURL);
                }
                else
                {
                    _gPictureBox.Visible = false;
                }
            }
        }

        public override bool DoSave()
        {
            if (UCDetails.DataManager.Current != null)
            {
                if (_gftpControlImage.IsFileExist)
                {
                    UCDetails.DataManager.Current.ImageFileID = _gftpControlImage.ID;
                    UCDetails.DataManager.Current.ImageFileURL = _gftpControlImage.URL;
                }
                else
                {
                    UCDetails.DataManager.Current.ImageFileID = null;
                    UCDetails.DataManager.Current.ImageFileURL = null;
                }
            }
            return true;
        }
    }
}
